using System;
using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;


[CustomEditor(typeof(TransferFunction))]
public class TransferFunctionEditorLegacy : Editor
{
    public const string SourceFolder = "Assets/Resources/TransferFunctions/";
    
    public override void OnInspectorGUI()
    {
        var transferFunction = (TransferFunction)target;
        
        GUILayout.Space(10);

        GUILayout.BeginHorizontal();
        
        /*if (GUILayout.Button("Save as preset"))
        {
            var window = EditorWindow.GetWindow<SaveTransferFunctionWindow>("Create preset");
            window.transferFunction = transferFunction;
            window.Show();
        }
        
        if (GUILayout.Button("Load from preset"))
        {
            var window = EditorWindow.GetWindow<LoadTransferFunctionWindow>("Load preset");
            window.transferFunction = transferFunction;
            window.Show();
        }*/
        
        GUILayout.EndHorizontal();

        if (!transferFunction.IsMonotonicIncreasing())
        {
            EditorGUILayout.HelpBox("This transfer function is not monotonic increasing. Therefore DDA is disabled and performance is significantly reduced.", MessageType.Warning);
        }

        if (GUILayout.Button("Edit transfer function"))
        {
            TransferFunctionEditorWindow.ShowWindow(transferFunction);
        }
        
        DrawDefaultInspector();

        
    }
}