using System;
using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

[CustomEditor(typeof(VolumeData))]
public class VolumeDataEditor : Editor
{
    public override void OnInspectorGUI()
    {
        var volumeData = (VolumeData)target;
        
        if (GUILayout.Button("Change format"))
        {
            VolumeDataFormatWindow.ShowWindow(volumeData);
        }
        
        DrawDefaultInspector();
    }
}

public class VolumeDataFormatWindow : EditorWindow
{
    public VolumeData volumeData;

    private VolumeFormat volumeFormat;
    private IndirectionFormat indirectionFormat;
    private AtlasFormat atlasFormat;
    private RangeFormat rangeFormat;
    private string windowName;
    private bool storeAsAsset = true;
    private bool createMipTextures = true;
    private bool keepRaw = true;

    public static void ShowWindow(VolumeData volumeData)
    {
        var window = EditorWindow.GetWindow<VolumeDataFormatWindow>("Select format");
        window.volumeData = volumeData;
        window.windowName = volumeData.dataName;
        window.Show();
    } 

    private void OnGUI()
    {
        volumeFormat = (VolumeFormat)EditorGUI.EnumPopup(new Rect(0, 0, position.width, 15), "VolumeFormat", volumeFormat);
        indirectionFormat = (IndirectionFormat)EditorGUI.EnumPopup(new Rect(0, 20, position.width, 15),
            "IndirectionFormat", indirectionFormat);
        atlasFormat = (AtlasFormat)EditorGUI.EnumPopup(new Rect(0, 40, position.width, 15),
            "AtlasFormat", atlasFormat);
        rangeFormat = (RangeFormat)
            EditorGUI.EnumPopup(new Rect(0, 60, position.width, 15),
            "RangeFormat", rangeFormat);
        GUILayout.Space(80);
        keepRaw = GUILayout.Toggle(keepRaw, "Keep Raw");
        storeAsAsset = GUILayout.Toggle(storeAsAsset, "Store as asset");
        createMipTextures = GUILayout.Toggle(createMipTextures, "Create Mip Textures");
        windowName = GUILayout.TextField(windowName);

        if (GUILayout.Button("Convert"))
        {
            volumeData.dataName = windowName;
            volumeData.BuildTextures(
                volumeFormat,
                rangeFormat,
                atlasFormat,
                indirectionFormat,
                3,
                createMipTextures,
                storeAsAsset,
                keepRaw
            );
            Debug.Log("Finished converting.");
        }
    }
}
