using System.Collections;
using System.Collections.Generic;
using UnityEditor;
using UnityEngine;

[CreateAssetMenu(menuName = "SceneVolumeRenderStates")]
public class SceneViewData : ScriptableObject 
{
    //add a variable that track which state of rednering the scene camera is, so it doesn't have to do work twice.

    public int maxSamples = 200;
    
    public CameraData cameraData = new CameraData();
    
    public List<VolumeRenderState> States = new List<VolumeRenderState>();

    public bool enableTonemapping = false;
    public float gamma = 1.0f;
    public float exposure = 1.0f;

    [SerializeField] public bool blendWithScene = true;

    public RenderTexture outputTexture;
    public RenderTexture depthTexture;
    public RenderTexture tempTexture;
    
#if UNITY_EDITOR
    public Camera Camera => SceneView.lastActiveSceneView == null ? null : SceneView.lastActiveSceneView.camera;
#else
    public Camera Camera => null;
#endif
}
