﻿#include "TraceUtil.cginc"

#pragma multi_compile_local _ USE_RAW_DATA

Texture3D vol_density_range;
Texture3D vol_density_indirection;
Texture3D vol_density_atlas; // also used for raw lookup when enabled

float vol_minorant; // unused
float vol_majorant;
float vol_inv_majorant;

float vol_density_scale;

// --------------------------------------------------------------
// volume sampling helpers (input vectors assumed in index space!)

// brick grid voxel density lookup (nearest neighbor)
float lookup_density_brick(const float3 ipos) {
    const int3 index = floor(ipos);
    const int3 brick = index >> 3;
    
    const float2 range = vol_density_range[brick].xy;
    const float3 ptr = vol_density_indirection[brick].xyz;
    const uint3 ptr_converted = ptr * 255;
    
    const float value_unorm = vol_density_atlas[(ptr_converted * 8) + (uint3(index) & 7)].x;
    
    return range.x + value_unorm * (range.y - range.x);
}

// density lookup (nearest neighbor)
float lookup_density(const float3 ipos) {
    return vol_density_scale * lookup_density_brick(ipos);
}

// density lookup (stochastic filter)
float lookup_density_stochastic(const float3 ipos, inout uint seed) {
    return lookup_density(ipos + rng3(seed) - .5f);
}

// brick majorant lookup (nearest neighbor)
float lookup_majorant(const float3 ipos, const int mip) {
    const int3 index = floor(ipos);
    const int3 brick = index >> (3 + mip);
    
    return vol_density_scale * vol_density_range.Load(int4(brick, mip)).y;
}

// density lookup (trilinear filter)
float lookup_density_trilinear(const float3 ipos) {
    const float3 f = frac(ipos - 0.5);
    const int3 iipos = int3(floor(ipos - 0.5));
    const float lx0 = lerp(lookup_density_brick(iipos + float3(0, 0, 0)), lookup_density_brick(iipos + float3(1, 0, 0)), f.x);
    const float lx1 = lerp(lookup_density_brick(iipos + float3(0, 1, 0)), lookup_density_brick(iipos + float3(1, 1, 0)), f.x);
    const float hx0 = lerp(lookup_density_brick(iipos + float3(0, 0, 1)), lookup_density_brick(iipos + float3(1, 0, 1)), f.x);
    const float hx1 = lerp(lookup_density_brick(iipos + float3(0, 1, 1)), lookup_density_brick(iipos + float3(1, 1, 1)), f.x);
    //return 1;
    
    return vol_density_scale * lerp(lerp(lx0, lx1, f.y), lerp(hx0, hx1, f.y), f.z);// / vol_density_transform[0].x;
    //vol_density_scale needs to be adjusted. should be inversly proportion to lossy scale. Or just divide scale
}
