using System;
using UnityEngine;


public enum LightType
{
    Directional,
    Point,
}

public class VolumeLight : MonoBehaviour
{
    public delegate void LightChanged();
    public LightChanged OnLightChanged;
    
    public delegate void LightEnabled();
    public LightEnabled OnLightEnabled;
    
    public delegate void LightDisabled();
    public LightDisabled OnLightDisabled;

    [SerializeField] private LightType lightType;

    private void Update()
    {
        if (transform.hasChanged)
        {
            transform.hasChanged = false;
            OnLightChanged?.Invoke();
        }
    }

    private void OnEnable()
    {
        OnLightEnabled?.Invoke();
    }

    private void OnDisable()
    {
        OnLightDisabled?.Invoke();
    }

    public void Bind(ComputeShader shader, ShaderIndices shaderIndices)
    {
        shader.DisableKeyword("USE_LIGHT_SOURCE_DIRECTIONAL");
        shader.DisableKeyword("USE_LIGHT_SOURCE_POINT");
        if (lightType == LightType.Point)
        {
            shader.EnableKeyword("USE_LIGHT_SOURCE_POINT");
        } else if (lightType == LightType.Directional)
        {
            shader.EnableKeyword("USE_LIGHT_SOURCE_DIRECTIONAL");
        }
        shader.SetVector(shaderIndices.LightWorldPos, transform.position);
        shader.SetVector(shaderIndices.LightWorldDir, transform.forward);
    }
}
