﻿using UnityEngine;
using UnityEngine.Events;
using System;

public class ConsoleOutput : MonoBehaviour
{
    private const string Ignore = "[Netcode] Syncing Time To Clients";
    private const int TruncationLength = 5000;

    [SerializeField] private bool triggerWhileDisabled = true;
    [SerializeField] private UnityEvent<string> onLogRecieved = new UnityEvent<string>();

    private static string fullLog = "";
    private string currentLog = "";

    private void Awake()
    {
        Application.logMessageReceived += UpdateLog;
        if (fullLog != "") UpdateLog("Detected scene change.", "", LogType.Log);
    }
    private void OnDestroy()
    {
        Application.logMessageReceived -= UpdateLog;
    }

    public void UpdateLog(string logString, string stackTrace, LogType type)
    {
        if (!isActiveAndEnabled && !triggerWhileDisabled) return;

        if ((currentLog.Contains(Ignore) || currentLog == ".") && logString.Contains(Ignore))
        {
            currentLog = ".";
        }
        else currentLog = $"\n<color=\"{LogColor(type)}\">{type.ToString()[0]}</color> [{DateTime.Now.TimeOfDay:hh\\:mm\\:ss}] {logString}";
        // else currentLog = $"\n{type.ToString()[0]} [{DateTime.Now.TimeOfDay:hh\\:mm\\:ss}] {logString}"; //uncomment to disable color

        fullLog = $"{fullLog}{currentLog}";
        if (fullLog.Length > TruncationLength)
        {
            fullLog = $"--Truncated--\n{fullLog.Substring(fullLog.Length - TruncationLength)}";
        }

        onLogRecieved?.Invoke(fullLog);
    }

    public string LogColor(LogType logType)
    {
        return logType switch
        {
            LogType.Error => "red",
            LogType.Assert => "black",
            LogType.Warning => "yellow",
            LogType.Log => "grey",
            LogType.Exception => "orange",
            _ => "pink",
        };
    }

    public void Log(string message) => Debug.Log(message);
    public void LogWarning(string message) => Debug.LogWarning(message);
    public void LogError(string message) => Debug.LogError(message);
}
