using UnityEngine;
using UnityEditor.Build;
using UnityEditor.Build.Reporting;
using UnityEditor;
using System.IO;

[InitializeOnLoad]
public class OnBuild : IPreprocessBuildWithReport, IPostprocessBuildWithReport
{
    public int callbackOrder => 0;
    
    private static VersionNumber versionNumber = new VersionNumber();

    static OnBuild() => EditorApplication.playModeStateChanged += OnExitPlayMode;
    private static void OnExitPlayMode(PlayModeStateChange state)
    {
        if (state == PlayModeStateChange.EnteredEditMode) 
            versionNumber[0] += 1;
    }

    public void OnPreprocessBuild(BuildReport report)
    {
        string rootFolderName = new DirectoryInfo(Application.dataPath).Parent.Name;
        
        //Include the version number in the build name
        PlayerSettings.productName = $"{rootFolderName} ({PlayerSettings.bundleVersion})";
        
        //Many builds won't work as DefaultCompany, anything else is preferable
        if(PlayerSettings.companyName == "DefaultCompany") PlayerSettings.companyName = rootFolderName;

        //Deletes build folder
        // System.IO.DirectoryInfo directoryInfo = new DirectoryInfo(@"C:\Users\lucas\Desktop\Unity\_Builds\The Organizer");
        // foreach (FileInfo file in directoryInfo.GetFiles())
        // {
        //     file.Delete();
        // }
        // foreach (DirectoryInfo dir in directoryInfo.GetDirectories())
        // {
        //     dir.Delete(true);
        // }
    }

    public void OnPostprocessBuild(BuildReport report)
    {
        versionNumber[1] += 1;
        //versionNumber[0] = 0;

        Debug.Log($"{report.summary.platform} Build <{report.summary.totalSize / 1_000_000d:F2}MB>" +
            $"\n(GUID: {report.summary.guid.ToString().Substring(0, 6)})");
    }
}


public class VersionNumber
{
    /// <summary>
    /// Directly change the individual values within the version number.
    /// </summary>
    /// <param name="subVersion">0 is the right-most sub-version.</param>
    public int this[int subVersion]
    {
        get
        {
            string[] subVersions = PlayerSettings.bundleVersion.Split(".");
            return int.Parse(subVersions[subVersions.Length-1 - subVersion]);
        }
        set
        {
            string[] subVersions = PlayerSettings.bundleVersion.Split(".");
            subVersions[subVersions.Length-1 - subVersion] = value.ToString("D2");
            PlayerSettings.bundleVersion = string.Join(".", subVersions);
        }
    }
}
